(window.yoastPremiumWebpackJsonp=window.yoastPremiumWebpackJsonp||[]).push([[4],{100:function(module,exports,__webpack_require__){"use strict";eval('\n\nObject.defineProperty(exports, "__esModule", {\n\tvalue: true\n});\n\nvar _functions = __webpack_require__(19);\n\n/**\n * Client side validator for the redirect.\n *\n * @param {RedirectForm} form Form object representing the form.\n * @param {string} type       The redirect type.\n *\n * @returns {void}\n */\nvar ValidateRedirect = function ValidateRedirect(form, type) {\n\tthis.form = form;\n\tthis.type = type;\n\tthis.validationError = "";\n};\n\n/**\n * Validates the form fields.\n *\n * @returns {boolean} True when validation has been successful.\n */\n/* global wpseoPremiumStrings */\nValidateRedirect.prototype.validate = function () {\n\tthis.form.clearErrorMessage();\n\tthis.form.removeRowHighlights();\n\n\tif (this.runValidation(this.form.getOriginField(), this.form.getTargetField(), this.form.getTypeField()) === false) {\n\t\tthis.addValidationError(this.validationError);\n\n\t\treturn false;\n\t}\n\n\treturn true;\n};\n\n/**\n * Executes the validation.\n *\n * @param {element} originField The origin field.\n * @param {element} targetField The target field.\n * @param {element} typeField   The type field.\n * @returns {boolean} True when validation has been successful.\n */\nValidateRedirect.prototype.runValidation = function (originField, targetField, typeField) {\n\t// Check old URL.\n\tif ("" === originField.val()) {\n\t\tthis.form.highlightRow(originField);\n\n\t\tif ("plain" === this.type) {\n\t\t\treturn this.setError(wpseoPremiumStrings.error_old_url);\n\t\t}\n\n\t\treturn this.setError(wpseoPremiumStrings.error_regex);\n\t}\n\n\t// Only when the redirect type is not deleted.\n\tif (jQuery.inArray(parseInt(typeField.val(), 10), _functions.ALLOW_EMPTY_TARGET) === -1) {\n\t\t// Check new URL.\n\t\tif ("" === targetField.val()) {\n\t\t\tthis.form.highlightRow(targetField);\n\t\t\treturn this.setError(wpseoPremiumStrings.error_new_url);\n\t\t}\n\n\t\t// Check if both fields aren\'t the same.\n\t\tif (targetField.val() === originField.val()) {\n\t\t\tthis.form.highlightRow(targetField);\n\t\t\treturn this.setError(wpseoPremiumStrings.error_circular);\n\t\t}\n\t}\n\n\t// Check the redirect type.\n\tif ("" === typeField.val()) {\n\t\tthis.form.highlightRow(typeField);\n\t\treturn this.setError(wpseoPremiumStrings.error_new_type);\n\t}\n\n\treturn true;\n};\n\n/**\n * Sets the validation error and return false.\n *\n * @param {string} error The error to set.\n * @returns {boolean} False, because there is an error.\n */\nValidateRedirect.prototype.setError = function (error) {\n\tthis.validationError = error;\n\n\treturn false;\n};\n\n/**\n * Adding the validation error.\n *\n * @param {string} error  The error message.\n * @param {object} fields The fields related to the error.\n *\n * @returns {void}\n */\nValidateRedirect.prototype.addValidationError = function (error) {\n\tvar fields = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : null;\n\n\tthis.form.setErrorMessage(error);\n\n\tif (typeof fields !== "undefined") {\n\t\tthis.form.highLightRowErrors(fields);\n\t}\n};\n\n/**\n * Returns the values on the quick edit form.\n *\n * @returns {{origin: (string|*), target: (string|*), type: (string|*)}} Object with the form values.\n */\nValidateRedirect.prototype.getFormValues = function () {\n\tvar values = {\n\t\torigin: this.form.getOriginField().val().toString(),\n\t\ttarget: this.form.getTargetField().val().toString(),\n\t\ttype: this.form.getTypeField().val().toString()\n\t};\n\n\t// When the redirect type is deleted or unavailable, the target can be emptied.\n\tif (jQuery.inArray(parseInt(values.type, 10), _functions.ALLOW_EMPTY_TARGET) > -1) {\n\t\tvalues.target = "";\n\t}\n\n\treturn values;\n};\n\nexports.default = ValidateRedirect;//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiMTAwLmpzIiwic291cmNlcyI6WyJ3ZWJwYWNrOi8vL2Fzc2V0cy9qcy9zcmMvcmVkaXJlY3RzL3ZhbGlkYXRlLXJlZGlyZWN0LmpzP2RhMGQiXSwic291cmNlc0NvbnRlbnQiOlsiLyogZ2xvYmFsIHdwc2VvUHJlbWl1bVN0cmluZ3MgKi9cbmltcG9ydCB7IEFMTE9XX0VNUFRZX1RBUkdFVCB9IGZyb20gXCIuL2Z1bmN0aW9uc1wiO1xuXG4vKipcbiAqIENsaWVudCBzaWRlIHZhbGlkYXRvciBmb3IgdGhlIHJlZGlyZWN0LlxuICpcbiAqIEBwYXJhbSB7UmVkaXJlY3RGb3JtfSBmb3JtIEZvcm0gb2JqZWN0IHJlcHJlc2VudGluZyB0aGUgZm9ybS5cbiAqIEBwYXJhbSB7c3RyaW5nfSB0eXBlICAgICAgIFRoZSByZWRpcmVjdCB0eXBlLlxuICpcbiAqIEByZXR1cm5zIHt2b2lkfVxuICovXG5jb25zdCBWYWxpZGF0ZVJlZGlyZWN0ID0gZnVuY3Rpb24oIGZvcm0sIHR5cGUgKSB7XG5cdHRoaXMuZm9ybSA9IGZvcm07XG5cdHRoaXMudHlwZSA9IHR5cGU7XG5cdHRoaXMudmFsaWRhdGlvbkVycm9yID0gXCJcIjtcbn07XG5cbi8qKlxuICogVmFsaWRhdGVzIHRoZSBmb3JtIGZpZWxkcy5cbiAqXG4gKiBAcmV0dXJucyB7Ym9vbGVhbn0gVHJ1ZSB3aGVuIHZhbGlkYXRpb24gaGFzIGJlZW4gc3VjY2Vzc2Z1bC5cbiAqL1xuVmFsaWRhdGVSZWRpcmVjdC5wcm90b3R5cGUudmFsaWRhdGUgPSBmdW5jdGlvbigpIHtcblx0dGhpcy5mb3JtLmNsZWFyRXJyb3JNZXNzYWdlKCk7XG5cdHRoaXMuZm9ybS5yZW1vdmVSb3dIaWdobGlnaHRzKCk7XG5cblx0aWYgKCB0aGlzLnJ1blZhbGlkYXRpb24oIHRoaXMuZm9ybS5nZXRPcmlnaW5GaWVsZCgpLCB0aGlzLmZvcm0uZ2V0VGFyZ2V0RmllbGQoKSwgdGhpcy5mb3JtLmdldFR5cGVGaWVsZCgpICkgPT09IGZhbHNlICkge1xuXHRcdHRoaXMuYWRkVmFsaWRhdGlvbkVycm9yKCB0aGlzLnZhbGlkYXRpb25FcnJvciApO1xuXG5cdFx0cmV0dXJuIGZhbHNlO1xuXHR9XG5cblx0cmV0dXJuIHRydWU7XG59O1xuXG4vKipcbiAqIEV4ZWN1dGVzIHRoZSB2YWxpZGF0aW9uLlxuICpcbiAqIEBwYXJhbSB7ZWxlbWVudH0gb3JpZ2luRmllbGQgVGhlIG9yaWdpbiBmaWVsZC5cbiAqIEBwYXJhbSB7ZWxlbWVudH0gdGFyZ2V0RmllbGQgVGhlIHRhcmdldCBmaWVsZC5cbiAqIEBwYXJhbSB7ZWxlbWVudH0gdHlwZUZpZWxkICAgVGhlIHR5cGUgZmllbGQuXG4gKiBAcmV0dXJucyB7Ym9vbGVhbn0gVHJ1ZSB3aGVuIHZhbGlkYXRpb24gaGFzIGJlZW4gc3VjY2Vzc2Z1bC5cbiAqL1xuVmFsaWRhdGVSZWRpcmVjdC5wcm90b3R5cGUucnVuVmFsaWRhdGlvbiA9IGZ1bmN0aW9uKCBvcmlnaW5GaWVsZCwgdGFyZ2V0RmllbGQsIHR5cGVGaWVsZCApIHtcblx0Ly8gQ2hlY2sgb2xkIFVSTC5cblx0aWYgKCBcIlwiID09PSBvcmlnaW5GaWVsZC52YWwoKSApIHtcblx0XHR0aGlzLmZvcm0uaGlnaGxpZ2h0Um93KCBvcmlnaW5GaWVsZCApO1xuXG5cdFx0aWYgKCBcInBsYWluXCIgPT09IHRoaXMudHlwZSApIHtcblx0XHRcdHJldHVybiB0aGlzLnNldEVycm9yKCB3cHNlb1ByZW1pdW1TdHJpbmdzLmVycm9yX29sZF91cmwgKTtcblx0XHR9XG5cblx0XHRyZXR1cm4gdGhpcy5zZXRFcnJvciggd3BzZW9QcmVtaXVtU3RyaW5ncy5lcnJvcl9yZWdleCApO1xuXHR9XG5cblx0Ly8gT25seSB3aGVuIHRoZSByZWRpcmVjdCB0eXBlIGlzIG5vdCBkZWxldGVkLlxuXHRpZiAoIGpRdWVyeS5pbkFycmF5KCBwYXJzZUludCggdHlwZUZpZWxkLnZhbCgpLCAxMCApLCBBTExPV19FTVBUWV9UQVJHRVQgKSA9PT0gLTEgKSB7XG5cdFx0Ly8gQ2hlY2sgbmV3IFVSTC5cblx0XHRpZiAoIFwiXCIgPT09IHRhcmdldEZpZWxkLnZhbCgpICkge1xuXHRcdFx0dGhpcy5mb3JtLmhpZ2hsaWdodFJvdyggdGFyZ2V0RmllbGQgKTtcblx0XHRcdHJldHVybiB0aGlzLnNldEVycm9yKCB3cHNlb1ByZW1pdW1TdHJpbmdzLmVycm9yX25ld191cmwgKTtcblx0XHR9XG5cblx0XHQvLyBDaGVjayBpZiBib3RoIGZpZWxkcyBhcmVuJ3QgdGhlIHNhbWUuXG5cdFx0aWYgKCB0YXJnZXRGaWVsZC52YWwoKSA9PT0gb3JpZ2luRmllbGQudmFsKCkgKSB7XG5cdFx0XHR0aGlzLmZvcm0uaGlnaGxpZ2h0Um93KCB0YXJnZXRGaWVsZCApO1xuXHRcdFx0cmV0dXJuIHRoaXMuc2V0RXJyb3IoIHdwc2VvUHJlbWl1bVN0cmluZ3MuZXJyb3JfY2lyY3VsYXIgKTtcblx0XHR9XG5cdH1cblxuXHQvLyBDaGVjayB0aGUgcmVkaXJlY3QgdHlwZS5cblx0aWYgKCBcIlwiID09PSB0eXBlRmllbGQudmFsKCkgKSB7XG5cdFx0dGhpcy5mb3JtLmhpZ2hsaWdodFJvdyggdHlwZUZpZWxkICk7XG5cdFx0cmV0dXJuIHRoaXMuc2V0RXJyb3IoIHdwc2VvUHJlbWl1bVN0cmluZ3MuZXJyb3JfbmV3X3R5cGUgKTtcblx0fVxuXG5cdHJldHVybiB0cnVlO1xufTtcblxuLyoqXG4gKiBTZXRzIHRoZSB2YWxpZGF0aW9uIGVycm9yIGFuZCByZXR1cm4gZmFsc2UuXG4gKlxuICogQHBhcmFtIHtzdHJpbmd9IGVycm9yIFRoZSBlcnJvciB0byBzZXQuXG4gKiBAcmV0dXJucyB7Ym9vbGVhbn0gRmFsc2UsIGJlY2F1c2UgdGhlcmUgaXMgYW4gZXJyb3IuXG4gKi9cblZhbGlkYXRlUmVkaXJlY3QucHJvdG90eXBlLnNldEVycm9yID0gZnVuY3Rpb24oIGVycm9yICkge1xuXHR0aGlzLnZhbGlkYXRpb25FcnJvciA9IGVycm9yO1xuXG5cdHJldHVybiBmYWxzZTtcbn07XG5cbi8qKlxuICogQWRkaW5nIHRoZSB2YWxpZGF0aW9uIGVycm9yLlxuICpcbiAqIEBwYXJhbSB7c3RyaW5nfSBlcnJvciAgVGhlIGVycm9yIG1lc3NhZ2UuXG4gKiBAcGFyYW0ge29iamVjdH0gZmllbGRzIFRoZSBmaWVsZHMgcmVsYXRlZCB0byB0aGUgZXJyb3IuXG4gKlxuICogQHJldHVybnMge3ZvaWR9XG4gKi9cblZhbGlkYXRlUmVkaXJlY3QucHJvdG90eXBlLmFkZFZhbGlkYXRpb25FcnJvciA9IGZ1bmN0aW9uKCBlcnJvciwgZmllbGRzID0gbnVsbCApIHtcblx0dGhpcy5mb3JtLnNldEVycm9yTWVzc2FnZSggZXJyb3IgKTtcblxuXHRpZiAoIHR5cGVvZiBmaWVsZHMgIT09IFwidW5kZWZpbmVkXCIgKSB7XG5cdFx0dGhpcy5mb3JtLmhpZ2hMaWdodFJvd0Vycm9ycyggZmllbGRzICk7XG5cdH1cbn07XG5cbi8qKlxuICogUmV0dXJucyB0aGUgdmFsdWVzIG9uIHRoZSBxdWljayBlZGl0IGZvcm0uXG4gKlxuICogQHJldHVybnMge3tvcmlnaW46IChzdHJpbmd8KiksIHRhcmdldDogKHN0cmluZ3wqKSwgdHlwZTogKHN0cmluZ3wqKX19IE9iamVjdCB3aXRoIHRoZSBmb3JtIHZhbHVlcy5cbiAqL1xuVmFsaWRhdGVSZWRpcmVjdC5wcm90b3R5cGUuZ2V0Rm9ybVZhbHVlcyA9IGZ1bmN0aW9uKCkge1xuXHRjb25zdCB2YWx1ZXMgPSB7XG5cdFx0b3JpZ2luOiB0aGlzLmZvcm0uZ2V0T3JpZ2luRmllbGQoKS52YWwoKS50b1N0cmluZygpLFxuXHRcdHRhcmdldDogdGhpcy5mb3JtLmdldFRhcmdldEZpZWxkKCkudmFsKCkudG9TdHJpbmcoKSxcblx0XHR0eXBlOiB0aGlzLmZvcm0uZ2V0VHlwZUZpZWxkKCkudmFsKCkudG9TdHJpbmcoKSxcblx0fTtcblxuXHQvLyBXaGVuIHRoZSByZWRpcmVjdCB0eXBlIGlzIGRlbGV0ZWQgb3IgdW5hdmFpbGFibGUsIHRoZSB0YXJnZXQgY2FuIGJlIGVtcHRpZWQuXG5cdGlmICggalF1ZXJ5LmluQXJyYXkoIHBhcnNlSW50KCB2YWx1ZXMudHlwZSwgMTAgKSwgQUxMT1dfRU1QVFlfVEFSR0VUICkgPiAtMSApIHtcblx0XHR2YWx1ZXMudGFyZ2V0ID0gXCJcIjtcblx0fVxuXG5cdHJldHVybiB2YWx1ZXM7XG59O1xuXG5leHBvcnQgZGVmYXVsdCBWYWxpZGF0ZVJlZGlyZWN0O1xuIl0sIm1hcHBpbmdzIjoiOzs7Ozs7QUFDQTtBQUNBO0FBQ0E7Ozs7Ozs7O0FBUUE7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7Ozs7O0FBakJBO0FBc0JBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7Ozs7Ozs7O0FBUUE7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7Ozs7OztBQU1BO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBOzs7Ozs7OztBQVFBO0FBQUE7QUFDQTtBQUFBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7Ozs7O0FBS0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUhBO0FBQ0E7QUFLQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0EiLCJzb3VyY2VSb290IjoiIn0=\n//# sourceURL=webpack-internal:///100\n')},101:function(module,exports,__webpack_require__){"use strict";eval('\n\nObject.defineProperty(exports, "__esModule", {\n  value: true\n});\n/* global wp, _ */\n\n/**\n * The quick edit prototype for handling the quick edit on form rows.\n * @constructor\n */\nvar RedirectQuickEdit = function RedirectQuickEdit() {\n  this.row = null;\n  this.quickEditRow = null;\n  this.templateQuickEdit = wp.template("redirects-inline-edit");\n};\n\n/**\n * Sets up the quick edit for a row, with the given row values.\n *\n * @param {element} row     The form row object.\n * @param {object} rowCells The form row cells.\n *\n * @returns {void}\n */\nRedirectQuickEdit.prototype.setup = function (row, rowCells) {\n  this.row = row;\n  this.quickEditRow = jQuery(this.templateQuickEdit({\n    origin: _.unescape(rowCells.origin.html()),\n    target: _.unescape(rowCells.target.html()),\n    type: parseInt(rowCells.type.html(), 10),\n    suffix: jQuery("#the-list").find("tr").index(row)\n  }));\n};\n\n/**\n * Returns the original row element.\n *\n * @returns {element} The row object.\n */\nRedirectQuickEdit.prototype.getRow = function () {\n  return this.row;\n};\n\n/**\n * Returns the original form element.\n *\n * @returns {element} The form object.\n */\nRedirectQuickEdit.prototype.getForm = function () {\n  return this.quickEditRow;\n};\n\n/**\n * Shows the quick edit form and hides the redirect row.\n *\n * @returns {void}\n */\nRedirectQuickEdit.prototype.show = function () {\n  this.row.addClass("hidden");\n  this.quickEditRow.insertAfter(this.row).show(400, function () {\n    jQuery(this).find(":input").first().trigger("focus");\n  });\n};\n\n/**\n * Hides the quick edit form and show the redirect row.\n *\n * @returns {void}\n */\nRedirectQuickEdit.prototype.remove = function () {\n  this.row.removeClass("hidden");\n  this.quickEditRow.remove();\n};\n\nexports.default = RedirectQuickEdit;//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,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\n//# sourceURL=webpack-internal:///101\n')},19:function(module,exports,__webpack_require__){"use strict";eval('\n\nObject.defineProperty(exports, "__esModule", {\n\tvalue: true\n});\nexports.ALLOW_EMPTY_TARGET = undefined;\nexports.wpseoDeleteRedirect = wpseoDeleteRedirect;\nexports.wpseoUndoRedirectForObject = wpseoUndoRedirectForObject;\nexports.wpseoRemoveNotification = wpseoRemoveNotification;\nexports.wpseoUndoRedirect = wpseoUndoRedirect;\nexports.wpseoUndoRedirectByObjectId = wpseoUndoRedirectByObjectId;\nexports.wpseoCreateRedirect = wpseoCreateRedirect;\n\nvar _apiFetch = __webpack_require__(9);\n\nvar _apiFetch2 = _interopRequireDefault(_apiFetch);\n\nfunction _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }\n\nvar ALLOW_EMPTY_TARGET = exports.ALLOW_EMPTY_TARGET = [410, 451];\n\n/**\n * Deletes a redirect.\n *\n * @param {string} origin The redirect\'s origin.\n * @param {string} target The redirect\'s target.\n * @param {string} type   The type of redirect.\n * @param {string} format The format of redirect.\n *\n * @returns {void}\n */\n/* global window, wpApiSettings, wpseoPremiumStrings, ajaxurl */\nfunction wpseoDeleteRedirect(origin, target, type) {\n\tvar format = arguments.length > 3 && arguments[3] !== undefined ? arguments[3] : "plain";\n\n\treturn (0, _apiFetch2.default)({\n\t\tmethod: "POST",\n\t\turl: wpApiSettings.root + "yoast/v1/redirects/delete",\n\t\theaders: {\n\t\t\t"X-WP-Nonce": wpApiSettings.nonce\n\t\t},\n\t\tdata: {\n\t\t\torigin: origin,\n\t\t\ttarget: target,\n\t\t\ttype: type,\n\t\t\tformat: format\n\t\t}\n\t});\n}\n\n/**\n * Deletes a redirect based on a post or term ID.\n *\n * @param {number} objectId   The post or term ID.\n * @param {number} objectType The object type: post or term.\n *\n * @returns {void}\n */\nfunction wpseoUndoRedirectForObject(objectId, objectType) {\n\treturn (0, _apiFetch2.default)({\n\t\tmethod: "POST",\n\t\turl: wpApiSettings.root + "yoast/v1/redirects/undo-for-object",\n\t\theaders: {\n\t\t\t"X-WP-Nonce": wpApiSettings.nonce\n\t\t},\n\t\tdata: {\n\t\t\t/* eslint-disable-next-line camelcase */\n\t\t\tobj_id: objectId,\n\t\t\t/* eslint-disable-next-line camelcase */\n\t\t\tobj_type: objectType\n\t\t}\n\t});\n}\n\n/**\n * Removes a notification.\n *\n * @param {object} source The DOMElement containing the alerts.\n *\n * @returns {void}\n */\nfunction wpseoRemoveNotification(source) {\n\tjQuery(source).closest(".yoast-notification").fadeOut("slow");\n}\n\n/**\n * Undoes a redirect.\n *\n * @param {string} origin The redirect\'s origin.\n * @param {string} target The redirect\'s target.\n * @param {string} type The type of redirect.\n * @param {string} nonce The nonce being used to validate the current AJAX request.\n * @param {object} source The DOMElement containing the alerts.\n *\n * @returns {void}\n */\nfunction wpseoUndoRedirect(origin, target, type, nonce, source) {\n\twpseoDeleteRedirect(origin, target, type).then(function (response) {\n\t\tif (response.success === true) {\n\t\t\twpseoRemoveNotification(source);\n\t\t}\n\t});\n}\n\n/**\n * Undoes a redirect based on a post or term ID.\n *\n * @param {number} objectId   The post or term ID.\n * @param {number} objectType The object type: post or term.\n * @param {object} source     The DOMElement containing the alerts.\n *\n * @returns {void}\n */\nfunction wpseoUndoRedirectByObjectId(objectId, objectType, source) {\n\twpseoUndoRedirectForObject(objectId, objectType).then(function (response) {\n\t\tif (response.success === true) {\n\t\t\twpseoRemoveNotification(source);\n\t\t}\n\t});\n}\n\n/**\n * Creates a redirect\n *\n * @param {string} origin The origin.\n * @param {string} type   The redirect type, regex or plain.\n * @param {string} nonce  The nonce.\n * @param {object} source The source of the redirect.\n *\n * @returns {void}\n */\nfunction wpseoCreateRedirect(origin, type, nonce, source) {\n\tvar target = "";\n\n\tif (parseInt(type, 10) !== 410) {\n\t\t/* eslint-disable no-alert */\n\t\ttarget = window.prompt(wpseoPremiumStrings.enter_new_url.replace("%s", origin));\n\t\t/* eslint-enable no-alert */\n\n\t\tif (target === "") {\n\t\t\t/* eslint-disable no-alert */\n\t\t\twindow.alert(wpseoPremiumStrings.error_new_url);\n\t\t\t/* eslint-enable no-alert */\n\t\t\treturn;\n\t\t}\n\t}\n\n\tjQuery.post(ajaxurl, {\n\t\taction: "wpseo_add_redirect_plain",\n\t\t/* eslint-disable-next-line camelcase */\n\t\tajax_nonce: nonce,\n\t\tredirect: {\n\t\t\torigin: origin,\n\t\t\ttarget: target,\n\t\t\ttype: type\n\t\t}\n\t}, function (response) {\n\t\tvar notice = jQuery(source).closest(".yoast-notification");\n\t\t// Remove the classes first.\n\t\tjQuery(notice).removeClass("updated").removeClass("error");\n\n\t\t// Remove possibly added redirect errors.\n\t\tjQuery(notice).find(".redirect_error").remove();\n\n\t\tif (response.error) {\n\t\t\t// Add paragraph on top of the notice with actions and set class to error.\n\t\t\tjQuery(notice).addClass("error").prepend("<p class=\\"redirect_error\\">" + response.error.message + "</p>");\n\n\t\t\treturn;\n\t\t}\n\n\t\t// Parse the success message.\n\t\tvar successMessage = "";\n\t\tif (parseInt(type, 10) === 410) {\n\t\t\tsuccessMessage = wpseoPremiumStrings.redirect_saved_no_target;\n\t\t} else {\n\t\t\tsuccessMessage = wpseoPremiumStrings.redirect_saved.replace("%2$s", "<code>" + response.target + "</code>");\n\t\t}\n\n\t\tsuccessMessage = successMessage.replace("%1$s", "<code>" + response.origin + "</code>");\n\n\t\t// Set class to updated and replace html with the success message.\n\t\tjQuery(notice).addClass("updated").html("<p>" + successMessage + "</p>");\n\t}, "json");\n}//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,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\n//# sourceURL=webpack-internal:///19\n')},9:function(module,exports){eval("module.exports = window.wp.apiFetch;//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiOS5qcyIsInNvdXJjZXMiOlsid2VicGFjazovLy9leHRlcm5hbCBcIndpbmRvdy53cC5hcGlGZXRjaFwiP2JjMGYiXSwic291cmNlc0NvbnRlbnQiOlsibW9kdWxlLmV4cG9ydHMgPSB3aW5kb3cud3AuYXBpRmV0Y2g7Il0sIm1hcHBpbmdzIjoiQUFBQSIsInNvdXJjZVJvb3QiOiIifQ==\n//# sourceURL=webpack-internal:///9\n")},98:function(module,exports,__webpack_require__){"use strict";eval('\n\nvar _functions = __webpack_require__(19);\n\nvar _redirectForm = __webpack_require__(99);\n\nvar _redirectForm2 = _interopRequireDefault(_redirectForm);\n\nvar _validateRedirect = __webpack_require__(100);\n\nvar _validateRedirect2 = _interopRequireDefault(_validateRedirect);\n\nvar _redirectQuickEdit = __webpack_require__(101);\n\nvar _redirectQuickEdit2 = _interopRequireDefault(_redirectQuickEdit);\n\nfunction _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }\n\n/* jshint -W097 */\n/* jshint -W098 */\n/* jshint -W107 */\n/* global ajaxurl, wpseoPremiumStrings, _, wpseoUserLocale */\n\n(function ($) {\n\tvar TABLE_COLUMNS = {\n\t\tORIGIN: 1,\n\t\tTARGET: 2,\n\t\tTYPE: 0\n\t};\n\n\tvar KEYS = {\n\t\tENTER: 13\n\t};\n\n\t// Instantiates the quick edit form.\n\tvar redirectsQuickEdit = new _redirectQuickEdit2.default();\n\n\t// Extend the jQuery UI dialog widget for our needs.\n\t$.widget("ui.dialog", $.ui.dialog, {\n\t\t/**\n   * Extends the `_createOverlay` function.\n   *\n   * @returns {void}\n   *\n   * @private\n   */\n\t\t_createOverlay: function _createOverlay() {\n\t\t\tthis._super();\n\t\t\t// If the modal option is true, add a click event on the overlay.\n\t\t\tif (this.options.modal) {\n\t\t\t\tthis._on(this.overlay, {\n\t\t\t\t\t/**\n      * Handles the onclick event for the modal.\n      *\n      * @param {Event} event The event.\n      *\n      * @returns {void}\n      */\n\t\t\t\t\tclick: function click(event) {\n\t\t\t\t\t\tthis.close(event);\n\t\t\t\t\t}\n\t\t\t\t});\n\t\t\t}\n\t\t}\n\t});\n\n\t/**\n  * Extending the elements with a wpseo_redirects object\n  *\n  * @param {string} argType The redirect table.\n  *\n  * @returns {void}\n  */\n\t$.fn.wpseoRedirects = function (argType) {\n\t\tvar that = this;\n\t\tvar redirectFormat = argType.replace("table-", "");\n\n\t\tvar ignore = false;\n\t\tvar lastAction = void 0;\n\n\t\t// The element focus keyboard should be moved back to.\n\t\tvar returnFocusToEl = null;\n\n\t\t/**\n   * Resets the ignore and lastAction.\n   *\n   * @returns {void}\n   */\n\t\tvar resetIgnore = function resetIgnore() {\n\t\t\tignore = false;\n\t\t\tlastAction = null;\n\t\t};\n\n\t\t/**\n   * Creates a button.\n   *\n   * @param {Object}        buttonProps The button value.\n   * @param {function|null} onClick     The event to trigger on click.\n   *\n   * @returns {Object} The button object.\n   */\n\t\tvar createButton = function createButton(buttonProps) {\n\t\t\tvar onClick = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : null;\n\t\t\tvar buttonValue = buttonProps.buttonValue,\n\t\t\t    _buttonProps$classNam = buttonProps.className,\n\t\t\t    className = _buttonProps$classNam === undefined ? "button" : _buttonProps$classNam;\n\n\n\t\t\treturn {\n\t\t\t\ttext: buttonValue,\n\t\t\t\t"class": className,\n\n\t\t\t\t/**\n     * Event to trigger onclick.\n     *\n     * @returns {void}\n     */\n\t\t\t\tclick: function click() {\n\t\t\t\t\tif (onClick !== null) {\n\t\t\t\t\t\tonClick();\n\t\t\t\t\t}\n\n\t\t\t\t\tjQuery(this).dialog("close");\n\t\t\t\t}\n\t\t\t};\n\t\t};\n\n\t\tthis.getButtons = function (dialogType) {\n\t\t\tif (dialogType === "default") {\n\t\t\t\treturn [createButton({\n\t\t\t\t\tbuttonValue: wpseoPremiumStrings.button_ok\n\t\t\t\t})];\n\t\t\t}\n\n\t\t\treturn [createButton({\n\t\t\t\tbuttonValue: wpseoPremiumStrings.button_cancel\n\t\t\t}, function () {\n\t\t\t\tresetIgnore();\n\t\t\t}), createButton({\n\t\t\t\tbuttonValue: wpseoPremiumStrings.button_save_anyway,\n\t\t\t\tclassName: "button-primary"\n\t\t\t}, function () {\n\t\t\t\tignore = true;\n\n\t\t\t\t// The value of last action will be the button pressed to save the redirect.\n\t\t\t\tlastAction();\n\n\t\t\t\tresetIgnore();\n\t\t\t})];\n\t\t};\n\n\t\t/**\n   * Returns a mapped object with the row column elements\n   *\n   * @param {Object} row The row object.\n   * @returns {{origin: *, target: *, type: *}} The values of the fields in the row.\n   */\n\t\tthis.rowCells = function (row) {\n\t\t\tvar rowValues = row.find(".val");\n\n\t\t\treturn {\n\t\t\t\torigin: rowValues.eq(TABLE_COLUMNS.ORIGIN),\n\t\t\t\ttarget: rowValues.eq(TABLE_COLUMNS.TARGET),\n\t\t\t\ttype: rowValues.eq(TABLE_COLUMNS.TYPE)\n\t\t\t};\n\t\t};\n\n\t\t/**\n   * Showing a dialog on the screen\n   *\n   * @param {string} title      Dialog title.\n   * @param {string} text       The text for the dialog.\n   * @param {string} dialogType The dialog type.\n   *\n   * @returns {void}\n   */\n\t\tthis.dialog = function (title, text, dialogType) {\n\t\t\tif (typeof dialogType === "undefined" || dialogType === "error") {\n\t\t\t\tdialogType = "default";\n\t\t\t}\n\n\t\t\tvar buttons = this.getButtons(dialogType);\n\n\t\t\t$("#YoastRedirectDialogText").html(text);\n\t\t\t$("#YoastRedirectDialog").dialog({\n\t\t\t\ttitle: title,\n\t\t\t\twidth: 500,\n\t\t\t\tdraggable: false,\n\t\t\t\tresizable: false,\n\t\t\t\tposition: {\n\t\t\t\t\tat: "center center",\n\t\t\t\t\tmy: "center center",\n\t\t\t\t\tof: window\n\t\t\t\t},\n\t\t\t\tbuttons: buttons,\n\t\t\t\tmodal: true,\n\t\t\t\t/**\n     * Focuses the return focus element if set.\n     *\n     * @returns {void}\n     */\n\t\t\t\tclose: function close() {\n\t\t\t\t\tif (returnFocusToEl) {\n\t\t\t\t\t\treturnFocusToEl.trigger("focus");\n\t\t\t\t\t}\n\t\t\t\t}\n\t\t\t});\n\t\t};\n\n\t\t/**\n   * Handle the response\n   *\n   * @param {object} successMessage The message that will be displayed on success.\n   *\n   * @returns {void}\n   */\n\t\tthis.openDialog = function (successMessage) {\n\t\t\tthis.dialog(successMessage.title, successMessage.message);\n\t\t};\n\n\t\t/**\n   * Sending post request.\n   *\n   * @param {object}   data       The data to post.\n   * @param {function} oncomplete Callback when request has been successful.\n   *\n   * @returns {void}\n   */\n\t\tthis.post = function (data, oncomplete) {\n\t\t\t$.post(ajaxurl, data, oncomplete, "json");\n\t\t};\n\n\t\t/**\n   * Creating an edit row for editing a redirect.\n   *\n   * @param {object} row The row to edit.\n   *\n   * @returns {void}\n   */\n\t\tthis.editRow = function (row) {\n\t\t\t// Just show a dialog when there is already a quick edit form opened.\n\t\t\tif ($("#the-list").find("#inline-edit").length > 0) {\n\t\t\t\t/* eslint-disable camelcase */\n\t\t\t\tthis.dialog(wpseoPremiumStrings.edit_redirect, wpseoPremiumStrings.editing_redirect);\n\t\t\t\t/* eslint-enable camelcase */\n\n\t\t\t\treturn;\n\t\t\t}\n\n\t\t\t// Running the setup and show the quick edit form.\n\t\t\tredirectsQuickEdit.setup(row, this.rowCells(row));\n\t\t\tredirectsQuickEdit.show();\n\n\t\t\tnew _redirectForm2.default(redirectsQuickEdit.quickEditRow).getTypeField().trigger("change");\n\t\t};\n\n\t\t/**\n   * Create a table row element with the new added redirect data\n   *\n   * @param {string} oldUrl       The old url.\n   * @param {string} newUrl       The new url.\n   * @param {string} redirectType The type of the redirect (regex or plain).\n   * @param {Object} redirectInfo  Object with details about the redirect.\n   * @returns {void|*|jQuery} The generated row.\n   */\n\t\tthis.createRedirectRow = function (oldUrl, newUrl, redirectType, redirectInfo) {\n\t\t\tvar targetClasses = ["val"];\n\n\t\t\tif (!redirectInfo.isTargetRelative || "" === newUrl || "/" === newUrl) {\n\t\t\t\ttargetClasses.push("remove-slashes");\n\t\t\t}\n\n\t\t\tif (redirectInfo.hasTrailingSlash) {\n\t\t\t\ttargetClasses.push("has-trailing-slash");\n\t\t\t}\n\n\t\t\treturn $("<tr>").append($("<th>").addClass("check-column").attr("scope", "row").append($("<input>").attr("name", "wpseo_redirects_bulk_delete[]").attr("type", "checkbox").val(_.escape(oldUrl)))).append($("<td>").addClass("type column-type has-row-actions column-primary").append($("<div>").addClass("val type").html(_.escape(redirectType))).append($("<div>").addClass("row-actions").append($("<span>").addClass("edit").append($("<a>").attr({ href: "#", role: "button", "class": "redirect-edit" }).html(wpseoPremiumStrings.editAction)).append(" | ")).append($("<span>").addClass("trash").append($("<a>").attr({ href: "#", role: "button", "class": "redirect-delete" }).html(wpseoPremiumStrings.deleteAction))))).append($("<td>").addClass("column-old").append($("<div>").addClass("val").html(_.escape(oldUrl)))).append($("<td>").addClass("column-new").append($("<div>").addClass(targetClasses.join(" ")).html(_.escape(newUrl))));\n\t\t};\n\n\t\t/**\n   * Handles the error.\n   *\n   * @param {ValidateRedirect} validateRedirect The validation object.\n   * @param {Object}           error            The error object.\n   *\n   * @returns {void}\n   */\n\t\tthis.handleError = function (validateRedirect, error) {\n\t\t\tvalidateRedirect.addValidationError(error.message, error.fields);\n\n\t\t\tif (error.type === "warning") {\n\t\t\t\tthat.dialog(wpseoPremiumStrings.error_saving_redirect, error.message, error.type);\n\t\t\t}\n\t\t};\n\n\t\t/**\n   * Adding the redirect\n   *\n   * @returns {boolean} True when redirect has been added successfully.\n   */\n\t\tthis.addRedirect = function () {\n\t\t\t// Do the validation.\n\t\t\tvar redirectForm = new _redirectForm2.default($(".wpseo-new-redirect-form"));\n\t\t\tvar validateRedirect = new _validateRedirect2.default(redirectForm, redirectFormat);\n\t\t\tif (validateRedirect.validate() === false) {\n\t\t\t\treturn false;\n\t\t\t}\n\n\t\t\tvar redirectValues = validateRedirect.getFormValues();\n\n\t\t\t// Do post.\n\t\t\tthat.post({\n\t\t\t\taction: "wpseo_add_redirect_" + redirectFormat,\n\t\t\t\t/* eslint-disable-next-line camelcase */\n\t\t\t\tajax_nonce: $(".wpseo_redirects_ajax_nonce").val(),\n\t\t\t\tredirect: {\n\t\t\t\t\torigin: encodeURIComponent(redirectValues.origin),\n\t\t\t\t\ttarget: encodeURIComponent(redirectValues.target),\n\t\t\t\t\ttype: redirectValues.type\n\t\t\t\t},\n\t\t\t\t/* eslint-disable-next-line camelcase */\n\t\t\t\tignore_warning: ignore\n\t\t\t}, function (response) {\n\t\t\t\tif (response.error) {\n\t\t\t\t\tthat.handleError(validateRedirect, response.error);\n\n\t\t\t\t\treturn true;\n\t\t\t\t}\n\n\t\t\t\t// Empty the form fields.\n\t\t\t\tredirectForm.getOriginField().val("");\n\t\t\t\tredirectForm.getTargetField().val("");\n\n\t\t\t\t// Remove the no items row.\n\t\t\t\tthat.find(".no-items").remove();\n\n\t\t\t\t// Creating tr.\n\t\t\t\tvar tr = that.createRedirectRow(response.origin, response.target, response.type, response.info);\n\n\t\t\t\t// Add the new row.\n\t\t\t\t$("form#" + redirectFormat).find("#the-list").prepend(tr);\n\n\t\t\t\tthat.openDialog(wpseoPremiumStrings.redirect_added);\n\t\t\t});\n\n\t\t\treturn true;\n\t\t};\n\n\t\t/**\n   * Updating the redirect\n   *\n   * @returns {boolean} True when updates is successful.\n   */\n\t\tthis.updateRedirect = function () {\n\t\t\t// Do the validation.\n\t\t\tvar redirectForm = new _redirectForm2.default(redirectsQuickEdit.getForm());\n\t\t\tvar validateRedirect = new _validateRedirect2.default(redirectForm, redirectFormat);\n\t\t\tif (validateRedirect.validate() === false) {\n\t\t\t\treturn false;\n\t\t\t}\n\n\t\t\tvar redirectValues = validateRedirect.getFormValues();\n\n\t\t\t// Setting the vars for the row and its values.\n\t\t\tvar row = redirectsQuickEdit.getRow();\n\t\t\tvar rowCells = this.rowCells(row);\n\n\t\t\t// Post the request.\n\t\t\tthat.post({\n\t\t\t\t/* eslint-disable camelcase */\n\t\t\t\taction: "wpseo_update_redirect_" + redirectFormat,\n\t\t\t\tajax_nonce: $(".wpseo_redirects_ajax_nonce").val(),\n\t\t\t\told_redirect: {\n\t\t\t\t\torigin: encodeURIComponent(rowCells.origin.html()),\n\t\t\t\t\ttarget: encodeURIComponent(rowCells.target.html()),\n\t\t\t\t\ttype: encodeURIComponent(rowCells.type.html())\n\t\t\t\t},\n\t\t\t\tnew_redirect: {\n\t\t\t\t\torigin: encodeURIComponent(redirectValues.origin),\n\t\t\t\t\ttarget: encodeURIComponent(redirectValues.target),\n\t\t\t\t\ttype: encodeURIComponent(redirectValues.type)\n\t\t\t\t},\n\t\t\t\tignore_warning: ignore\n\t\t\t}, function (response) {\n\t\t\t\tif (response.error) {\n\t\t\t\t\tthat.handleError(validateRedirect, response.error);\n\n\t\t\t\t\treturn true;\n\t\t\t\t}\n\n\t\t\t\t// Updates the table cells.\n\t\t\t\trowCells.origin.html(_.escape(response.origin));\n\t\t\t\trowCells.target.html(_.escape(response.target));\n\t\t\t\trowCells.type.html(_.escape(response.type));\n\n\t\t\t\tredirectsQuickEdit.remove();\n\n\t\t\t\tthat.openDialog(wpseoPremiumStrings.redirect_updated);\n\t\t\t}\n\t\t\t/* eslint-enable camelcase */\n\t\t\t);\n\n\t\t\treturn true;\n\t\t};\n\n\t\t/**\n   * Removes the redirect\n   *\n   * @param {Object} row The row object.\n   *\n   * @returns {void}\n   */\n\t\tthis.deleteRedirect = function (row) {\n\t\t\tvar _this = this;\n\n\t\t\tvar rowCells = this.rowCells(row);\n\n\t\t\tvar origin = rowCells.origin.html();\n\t\t\tvar target = rowCells.target.html();\n\t\t\tvar redirectType = rowCells.type.html();\n\n\t\t\t(0, _functions.wpseoDeleteRedirect)(origin, target, redirectType, redirectFormat).then(function (response) {\n\t\t\t\t// When the redirect is removed, just fade out the row and remove it after its faded.\n\t\t\t\trow.fadeTo("fast", 0).slideUp(function () {\n\t\t\t\t\t$(this).remove();\n\t\t\t\t});\n\n\t\t\t\tthat.openDialog(response);\n\t\t\t}).catch(function (error) {\n\t\t\t\t_this.dialog(error.title, error.message, "error");\n\t\t\t});\n\t\t};\n\n\t\t/**\n   * Running the setup of this element.\n   *\n   * @returns {void}\n   */\n\t\tthis.setup = function () {\n\t\t\tvar $row = void 0;\n\t\t\t// Adding dialog.\n\t\t\t$("body").append("<div id=\\"YoastRedirectDialog\\"><div id=\\"YoastRedirectDialogText\\"></div></div>");\n\n\t\t\t// When the window will be closed/reloaded and there is a inline edit opened show a message.\n\t\t\t$(window).on("beforeunload", function () {\n\t\t\t\tif ($("#the-list").find("#inline-edit").length > 0) {\n\t\t\t\t\treturn wpseoPremiumStrings.unsaved_redirects;\n\t\t\t\t}\n\t\t\t});\n\n\t\t\t// Adding the onchange event.\n\t\t\t$(".redirect-table-tab").on("change", "select[name=wpseo_redirects_type]", function (evt) {\n\t\t\t\tvar redirectType = parseInt($(evt.target).val(), 10);\n\t\t\t\tvar fieldToToggle = $(evt.target).closest(".wpseo_redirect_form").find(".wpseo_redirect_target_holder");\n\n\t\t\t\t// Hide the target field in case of a 410 redirect.\n\t\t\t\tif (jQuery.inArray(redirectType, _functions.ALLOW_EMPTY_TARGET) > -1) {\n\t\t\t\t\t$(fieldToToggle).hide();\n\n\t\t\t\t\treturn;\n\t\t\t\t}\n\t\t\t\t$(fieldToToggle).show();\n\t\t\t});\n\n\t\t\t// Adding events for the add form.\n\t\t\t$(".wpseo-new-redirect-form").on("click", ".button-primary", function () {\n\t\t\t\tlastAction = function lastAction() {\n\t\t\t\t\tthat.addRedirect();\n\t\t\t\t};\n\n\t\t\t\tthat.addRedirect();\n\t\t\t\treturnFocusToEl = $(this);\n\t\t\t\treturn false;\n\t\t\t}).on("keypress", "input", function (evt) {\n\t\t\t\tif (evt.which === KEYS.ENTER) {\n\t\t\t\t\tlastAction = function lastAction() {\n\t\t\t\t\t\tthat.addRedirect();\n\t\t\t\t\t};\n\n\t\t\t\t\tevt.preventDefault();\n\t\t\t\t\tthat.addRedirect();\n\t\t\t\t}\n\t\t\t});\n\n\t\t\t$(".wp-list-table").on("click", ".redirect-edit", function (evt) {\n\t\t\t\t$row = $(evt.target).closest("tr");\n\n\t\t\t\tevt.preventDefault();\n\t\t\t\tthat.editRow($row);\n\t\t\t\treturnFocusToEl = $(this);\n\t\t\t}).on("click", ".redirect-delete", function (evt) {\n\t\t\t\t$row = $(evt.target).closest("tr");\n\n\t\t\t\tevt.preventDefault();\n\t\t\t\tthat.deleteRedirect($row);\n\t\t\t\t// When a row gets deleted, where focus should land?\n\t\t\t\treturnFocusToEl = $("#cb-select-all-1");\n\t\t\t}).on("keypress", "input", function (evt) {\n\t\t\t\tif (evt.which === KEYS.ENTER) {\n\t\t\t\t\tlastAction = function lastAction() {\n\t\t\t\t\t\tthat.updateRedirect();\n\t\t\t\t\t};\n\n\t\t\t\t\tevt.preventDefault();\n\t\t\t\t\tthat.updateRedirect();\n\t\t\t\t}\n\t\t\t}).on("click", ".save", function () {\n\t\t\t\tlastAction = function lastAction() {\n\t\t\t\t\tthat.updateRedirect();\n\t\t\t\t};\n\n\t\t\t\tlastAction();\n\t\t\t}).on("click", ".cancel", function () {\n\t\t\t\tlastAction = null;\n\t\t\t\tredirectsQuickEdit.remove();\n\t\t\t\t// Move focus back to the Edit link.\n\t\t\t\t$row.find(".redirect-edit").trigger("focus");\n\t\t\t});\n\t\t};\n\n\t\tthat.setup();\n\t};\n\n\t/**\n  * Adds select2 for selected fields.\n  *\n  * @returns {void}\n  */\n\tfunction initSelect2() {\n\t\t$("#wpseo_redirects_type").select2({\n\t\t\twidth: "400px",\n\t\t\tlanguage: wpseoUserLocale.code,\n\t\t\tdropdownCssClass: "yoast-select__dropdown"\n\t\t});\n\t}\n\n\t/**\n  * Initializes the redirect page.\n  *\n  * @returns {void}\n  */\n\tfunction init() {\n\t\t$.each($(".redirect-table-tab"), function (key, element) {\n\t\t\t$(element).wpseoRedirects($(element).attr("id"));\n\t\t});\n\n\t\tinitSelect2();\n\t}\n\n\t$(init);\n})(jQuery);//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,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\n//# sourceURL=webpack-internal:///98\n')},99:function(module,exports,__webpack_require__){"use strict";eval('\n\nObject.defineProperty(exports, "__esModule", {\n  value: true\n});\n/**\n * Initialize a redirect form object.\n *\n * @param {element} form The redirect form.\n * @constructor\n */\nvar RedirectForm = function RedirectForm(form) {\n  this.form = form;\n};\n\n/**\n * Returns the origin field.\n *\n * @returns {element} The field for the redirect origin.\n */\nRedirectForm.prototype.getOriginField = function () {\n  return this.form.find("input[name=wpseo_redirects_origin]");\n};\n\n/**\n * Returns the target field.\n *\n * @returns {element} The field for the redirect target.\n */\nRedirectForm.prototype.getTargetField = function () {\n  return this.form.find("input[name=wpseo_redirects_target]");\n};\n\n/**\n * Returns the type field.\n *\n * @returns {element} The field for redirect type.\n */\nRedirectForm.prototype.getTypeField = function () {\n  return this.form.find("select[name=wpseo_redirects_type]");\n};\n\n/**\n * Clears the form error message.\n *\n * @returns {void}\n */\nRedirectForm.prototype.clearErrorMessage = function () {\n  this.form.find(".wpseo_redirect_form .form_error").remove();\n};\n\n/**\n * Sets a form error message.\n *\n * @param {string} errorMessage The error message to set.\n *\n * @returns {void}\n */\nRedirectForm.prototype.setErrorMessage = function (errorMessage) {\n  this.form.find(".wpseo_redirect_form").prepend("<div class=\\"form_error error\\"><p>" + errorMessage + "</p></div>");\n};\n\n/**\n * Removing the row errors.\n *\n * @returns {void}\n */\nRedirectForm.prototype.removeRowHighlights = function () {\n  this.form.find(".redirect_form_row").removeClass("field_error");\n};\n\n/**\n * Highlighting the row errors.\n *\n * @param {array} fieldsToHighlight The fields to highlight.\n *\n * @returns {void}\n */\nRedirectForm.prototype.highLightRowErrors = function (fieldsToHighlight) {\n  for (var i = 0; i < fieldsToHighlight.length; i++) {\n    switch (fieldsToHighlight[i]) {\n      case "origin":\n        this.highlightRow(this.getOriginField());\n        break;\n      case "target":\n        this.highlightRow(this.getTargetField());\n        break;\n      case "type":\n        this.highlightRow(this.getTypeField());\n        break;\n    }\n  }\n};\n\n/**\n * Highlights the closest row with an error class.\n *\n * @param {element} errorField The field to hightlight.\n *\n * @returns {void}\n */\nRedirectForm.prototype.highlightRow = function (errorField) {\n  jQuery(errorField).closest("div.redirect_form_row").addClass("field_error");\n};\n\nexports.default = RedirectForm;//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,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\n//# sourceURL=webpack-internal:///99\n')}},[[98,0]]]);