# Health Check

![Build Status](https://github.com/WordPress/health-check/workflows/Build%20Status/badge.svg)

Health Check is a WordPress plugin that will perform a number of checks on your WordPress install to detect common configuration errors and known issues.

It currently checks your PHP and MySQL versions, some extensions which are needed or may improve WordPress, and that the WordPress.org services are accessible to you.

The debug section, which allows you to gather information about your WordPress and server configuration that you may easily share with support representatives for themes, plugins or on the official WordPress.org support forums.

Troubleshooting allows you to have a vanilla WordPress session, where all plugins are disabled, and a default theme is used, but only for your user.

For a more extensive example of how to efficiently use the Health Check plugin, check out the [WordPress.org support team handbook page about this plugin](https://make.wordpress.org/support/handbook/appendix/troubleshooting-using-the-health-check/).

In the future we may introduce more checks, and welcome feedback both through the [WordPress.org forums](https://wordpress.org/support/plugin/health-check), and the [GitHub project page](https://github.com/WordPress/health-check).

## Installation

1. Upload to your plugins folder, usually `wp-content/plugins/`
2. Activate the plugin on the plugin screen.
3. Once activated the plugin will appear under your `Dashboard` menu.

## Contributing

Contributions are more than welcome, both through issues, and pull requests. Ideas and thoughts may also be discussed in the [#core-site-health](https://wordpress.slack.com/messages/core-site-health/) channel
on the [Making WordPress Slack](https://make.wordpress.org/chat) team.

For further information about contributing, see our [guide on contributing](https://github.com/WordPress/health-check/blob/master/.github/CONTRIBUTING.md).
