jQuery(document).ready(function( $ ) {
	
	$('.kg').mask('##0,00', {reverse: true});
	$('.mm').mask('##0,00', {reverse: true});
	
	// form-chapas-peso

	inputs = $('#fcp-form').find('input[type="text"]');
	
	var inputs = $('#fcp-form').find('input[type="text"], input[type="radio"]');
	inputs.change(function() {
		
		var tipo = $('input[name="fcp-tipo"]:checked').val();
		var espessura = parseFloat($("#fcp-espessura").val().replace(',','.'));
		var largura = parseFloat($("#fcp-largura").val().replace(',','.'));
		var comprimento = parseFloat($("#fcp-comprimento").val().replace(',','.'));
		
		var massa = 0;

		if (tipo == "A") {
			massa = 8.07;
		} else {
			massa = 7.92;
		}

		var total= (espessura * largura * comprimento * $("#fcp-qtd").val() * massa) / 1000000 ;
		
		var eVal = (isNaN(total)) ? 0 : parseFloat(total).toFixed(2);
		
        $("#fcp-total").val(eVal);
						
	});	
	
	// form-bobinas-comprimento

	inputs = $('#fbc-form').find('input[type="text"]');
	
	var inputs = $('#fbc-form').find('input[type="text"], input[type="radio"]');
	inputs.on("keyup change", function(e) {
		
		var tipo = $('input[name="fbc-tipo"]:checked').val();
		var constante = 0;
		var peso = parseFloat($("#fbc-peso").val().replace(',','.'));
		var espessura = parseFloat($("#fbc-espessura").val().replace(',','.'));
		var largura = parseFloat($("#fbc-largura").val().replace(',','.'));
		
		if (tipo == "A") {
			constante = 8070;
		} else {
			constante = 7920;
		}

		var total = ((1/constante) * peso)*(1000/(espessura)*(1000/largura));
		
		var eVal = (isNaN(total)) ? 0 : parseFloat(total).toFixed(2);
		
        $("#fbc-total").val(eVal);
						
	});		
	
	// form-bobinas-peso

	inputs = $('#fbp-form').find('input[type="text"]');
	
	var inputs = $('#fbp-form').find('input[type="text"], input[type="radio"]');
	inputs.on("keyup change", function(e) {
		
		var tipo = $('input[name="fbp-tipo"]:checked').val();
		var espessura = parseFloat($("#fbp-espessura").val().replace(',','.'));
		var largura = parseFloat($("#fbp-largura").val().replace(',','.'));
		var comprimento = parseFloat($("#fbp-comprimento").val().replace(',','.'));
		var constante = 0;
		
		if (tipo == "A") {
			constante = 8070;
		} else {
			constante = 7920;
		}

		var total = (espessura/1000)*(largura/1000)*(comprimento* constante)
		
		//var eVal = total;
		
		var eVal = (isNaN(total)) ? 0 : parseFloat(total).toFixed(2);
		
        $("#fbp-total").val(eVal);
						
	});			
	
	// form-barras-redondas

	inputs = $('#fbrd-form').find('input[type="text"]');
	
	var inputs = $('#fbrd-form').find('input[type="text"], input[type="radio"]');
	inputs.on("keyup change", function(e) {
		
		var tipo = $('input[name="fbrd-tipo"]:checked').val();
		var comprimento = parseFloat($("#fbrd-comprimento").val().replace(',','.'));
		var constante = 0;		
		var diametro = parseFloat($("#fbrd-diametro").val().replace(',','.'));
				
		if (tipo == "A") {		
			constante = 8.07;
		} else {
			constante = 7.92;
		}
		
		var raio = (diametro/2)*(diametro/2);

		var total = (Math.PI * raio * comprimento * $("#fbrd-qtd").val() * constante)/1000000;
		
		//alert(raio);
		
		//var eVal = total;
		
		var eVal = (isNaN(total)) ? 0 : parseFloat(total).toFixed(2);
		
        $("#fbrd-total").val(eVal);
						
	});		

	// form-barras-retangulares

	inputs = $('#fbrt-form').find('input[type="text"]');
	
	var inputs = $('#fbrt-form').find('input[type="text"], input[type="radio"]');
	inputs.on("keyup change", function(e) {
		
		var tipo = $('input[name="fbrt-tipo"]:checked').val();
		var espessura = parseFloat($("#fbrt-espessura").val().replace(',','.'));
		var largura = parseFloat($("#fbrt-largura").val().replace(',','.'));
		var comprimento = parseFloat($("#fbrt-comprimento").val().replace(',','.'));
		
		var constante = 0;
				
		if (tipo == "A") {		
			constante = 8.07;
		} else {
			constante = 7.92;
		}

		var total = (espessura * largura * comprimento * $("#fbrt-qtd").val() * constante)/1000000;
		
		//alert(raio);
		
		//var eVal = total;
		
		var eVal = (isNaN(total)) ? 0 : parseFloat(total).toFixed(2);
		
        $("#fbrt-total").val(eVal);
						
	});		
	
	// form-barras-cantoneira

	inputs = $('#fbrc-form').find('input[type="text"]');
	
	var inputs = $('#fbrc-form').find('input[type="text"], input[type="radio"]');
	inputs.on("keyup change", function(e) {
		
		var tipo = $('input[name="fbrc-tipo"]:checked').val();
		var espessura = parseFloat($("#fbrc-espessura").val().replace(',','.'));
		var largura = parseFloat($("#fbrc-largura").val().replace(',','.'));
		var comprimento = parseFloat($("#fbrc-comprimento").val().replace(',','.'));
		var qtd = $("#fbrc-qtd").val();
		
		var constante = 0;
				
		if (tipo == "A") {		
			constante = 8.07;
		} else {
			constante = 7.92;
		}
		
		var total = (((((2*largura)-espessura)*espessura*constante)/1000)*qtd)*(comprimento/1000)

		//var total = (espessura * largura * comprimento * $("#fbrc-qtd").val() * constante)/1000000;
		
		//alert(raio);
		
		//var eVal = total;
		
		var eVal = (isNaN(total)) ? 0 : parseFloat(total).toFixed(2);
		
        $("#fbrc-total").val(eVal);
						
	});		
	
	// form-tubos-redondos

	inputs = $('#ftrd-form').find('input[type="text"]');
	
	var inputs = $('#ftrd-form').find('input[type="text"], input[type="radio"]');
	inputs.on("keyup change", function(e) {
		
		var tipo = $('input[name="ftrd-tipo"]:checked').val();
		var espessura = parseFloat($("#ftrd-espessura").val().replace(',','.'));
		var diametro = parseFloat($("#ftrd-diametro").val().replace(',','.'));
		var comprimento = parseFloat($("#ftrd-comprimento").val().replace(',','.'));
		var qtd = $("#ftrd-qtd").val();		
		var constante = 0;
				
		if (tipo == "A") {		
			constante = 0.02503;
		} else {
			constante = 0.02463;
		}

		var total = (diametro-espessura)*espessura*constante*comprimento*qtd/1000
		
		//alert(raio);
		
		//var eVal = total;
		
		var eVal = (isNaN(total)) ? 0 : parseFloat(total).toFixed(2);
		
        $("#ftrd-total").val(eVal);
						
	});		
	
	// form-tubos-quadrados

	inputs = $('#ftqd-form').find('input[type="text"]');
	
	var inputs = $('#ftqd-form').find('input[type="text"], input[type="radio"]');
	inputs.on("keyup change", function(e) {
		
		var tipo = $('input[name="ftqd-tipo"]:checked').val();
		var espessura = parseFloat($("#ftqd-espessura").val().replace(',','.'));
		var lado = parseFloat($("#ftqd-lado").val().replace(',','.'));
		var comprimento = parseFloat($("#ftqd-comprimento").val().replace(',','.'));
		var qtd = $("#ftqd-qtd").val();		
		var constante = 0;
				
		if (tipo == "A") {		
			constante = 0.02503;
		} else {
			constante = 0.02463;
		}
		
		var total = ((((lado*1.27)-espessura)*espessura*constante)*comprimento*qtd/1000)
		
		//alert(raio);
		
		//var eVal = total;
		
		var eVal = (isNaN(total)) ? 0 : parseFloat(total).toFixed(2);
		
        $("#ftqd-total").val(eVal);
						
	});			 

	// form-tubos-retangulares

	inputs = $('#ftrt-form').find('input[type="text"]');
	
	var inputs = $('#ftrt-form').find('input[type="text"], input[type="radio"]');
	inputs.on("keyup change", function(e) {
		
		var tipo = $('input[name="ftrt-tipo"]:checked').val();
		var espessura = parseFloat($("#ftrt-espessura").val().replace(',','.'));
		var lado1 = parseFloat($("#ftrt-lado1").val().replace(',','.'));
		var lado2 = parseFloat($("#ftrt-lado2").val().replace(',','.'));
		var comprimento = parseFloat($("#ftrt-comprimento").val().replace(',','.'));
		var qtd = $("#ftrt-qtd").val();		
		var constante = 0;
				
		if (tipo == "A") {		
			constante = 0.02503;
		} else {
			constante = 0.02463;
		}
		
		var total = (((((lado1+lado2)/2)*1.27)-espessura)*espessura*constante)*comprimento*qtd/1000;
		
		//alert(raio);
		
		//var eVal = total;
		
		var eVal = (isNaN(total)) ? 0 : parseFloat(total).toFixed(2);
		
        $("#ftrt-total").val(eVal);
						
	});	
	
	var elmm = document.getElementById('mm');
	var elpo = document.getElementById('polegada');
	clickerMM = function() {
		elpo.selectedIndex = elmm.selectedIndex;
	}
	clickerPOL = function() {
		elmm.selectedIndex = elpo.selectedIndex;
	}
	elmm.addEventListener('change', clickerMM);
	elpo.addEventListener('change', clickerPOL)	
	 
});
