<?php

class GalaxPayWebhooks
{

    const WC_API_CALLBACK = 'galax_pay_webhook/';

    use GalaxActionStatusWebhook;

    protected $container, $isSubscription = false, $bill = null, $body = null;

    public function __construct(GalaxPaySettings $settings)
    {
        $this->container = $settings;
    }

    public function handle()
    {
        define('IS_WEBHOOK', true);
        $raw_body = file_get_contents('php://input');
        
        /*
        $statusTransaction = 'captured';
        $myId = '998';
        $galaxPayId = '287';
        $installment = 1;
        $galaxPayIdTransaction = '708';
        $myIdTransaction = '998';
        $raw_body = '{"event":"transaction.updateStatus","webhookId":"6332904","confirmHash":"9fab2a141d9effa5e1c4cf4f5487f5bd","Subscription":{"myId":"'.$myId.'","galaxPayId":'.$galaxPayId.',"value":13599,"paymentLink":"https:\/\/gpay.com.br\/c\/17323\/208\/b","mainPaymentMethodId":"boleto","status":"closed","additionalInfo":null,"createdAt":"2021-11-09 18:04:47","updatedAt":"2021-11-10 10:25:50","quantity":4,"periodicity":"monthly","firstPayDayDate":"2021-11-09","Customer":{"myId":"1","galaxPayId":1,"name":"Reteste testeeeee teste","document":"61368543090","createdAt":"2021-05-13 16:49:48","updatedAt":"2021-11-09 18:04:47","emails":["teste123535239fwae@galaxpay.com"],"phones":[3199011420,3140204512],"Address":{"zipCode":"30411325","street":"Rua S\u00e3o Jo\u00e3o, 11","number":"1375","complement":"Prado","neighborhood":"Prado","city":"BElo Ho","state":"MG"},"ExtraFields":[]},"ExtraFields":[],"PaymentMethodBoleto":{"fine":0,"interest":0,"instructions":"Pagamento feito atrav\u00e9s de loja virtual - Pedido C\u00f3digo 873","deadlineDays":1}},"Transaction":{"galaxPayId":'.$galaxPayIdTransaction.',"value":13599,"payday":"2022-02-09","paydayDate":"2021-11-10 10:25:50","installment":'.$installment.',"status":"'.$statusTransaction.'","statusDescription":"Paga fora do sistema","createdAt":"2021-11-09 18:04:51","myId":'.$myIdTransaction.',"additionalInfo":null,"subscriptionMyId":"873","subscriptionGalaxPayId":208,"payedOutsideGalaxPay":true,"Boleto":{"pdf":"https:\/\/data.galaxpay.com.br\/landing3723258331\/boleto\/202111MVMX6RO91JKCH7EXFW2T6ABIC09180451","bankLine":"03399022070600000201175051101014688910000013599","bankNumber":201750511},"Antifraud":{"ip":null,"sessionId":null,"sent":false,"approved":null},"Pix":{"qrCode":"00020101021226860014BR.GOV.BCB.PIX2564api.rendimento.com.br\/q\/v2\/cobv\/e4b368625f9c446784d6d9367c06d18d5204000053039865802BR5925DAYANNE BARBARA RAMOS REZ6014Belo Horizonte61083057544062070503***6304385E","image":"https:\/\/data.galaxpay.com.br\/landing3723258331\/pix\/APDI62ZZ2LTMOINYRSVS0000000560","page":"https:\/\/gpay.com.br\/q\/17323\/ac33fbce"}}}';
        
        
        $statusTransactionCharge = 'notCompensated';
        $myIdCharge = '914';
        $galaxPayIdCharge = '224';
        $galaxPayIdTransactionCharge = '607';
        $raw_body = '{"event":"transaction.updateStatus","webhookId":"6332904","confirmHash":"9fab2a141d9effa5e1c4cf4f5487f5bd","Charge":{"myId":"'.$myIdCharge.'","galaxPayId":'.$galaxPayIdCharge.',"value":3000,"paymentLink":"https:\/\/gpay.com.br\/c\/17323\/224\/b","mainPaymentMethodId":"boleto","status":"active","additionalInfo":null,"createdAt":"2021-11-12 10:13:44","updatedAt":"2021-11-12 10:13:44","payedOutsideGalaxPay":false,"Customer":{"myId":"1","galaxPayId":1,"name":"Reteste testeeeee teste","document":"61368543090","createdAt":"2021-05-13 16:49:48","updatedAt":"2021-11-12 10:13:44","emails":["teste123535239fwae@galaxpay.com"],"phones":[3199011420,3140204512],"Address":{"zipCode":"30411325","street":"Rua S\u00e3o Jo\u00e3o, 11","number":"1375","complement":"Prado","neighborhood":"Prado","city":"BElo Ho","state":"MG"},"ExtraFields":[]},"ExtraFields":[],"PaymentMethodBoleto":{"fine":0,"interest":0,"instructions":"Pagamento feito atrav\u00e9s de loja virtual - Pedido C\u00f3digo 914","deadlineDays":1}},"Transaction":{"galaxPayId":'.$galaxPayIdTransactionCharge.',"value":3000,"payday":"2021-11-12","paydayDate":null,"installment":1,"status":"'.$statusTransactionCharge.'","statusDescription":"Em aberto","createdAt":"2021-11-12 10:13:44","myId":null,"additionalInfo":null,"chargeGalaxPayId":'.$galaxPayIdCharge.',"chargeMyId":"'.$myIdCharge.'","Boleto":{"pdf":"https:\/\/data.galaxpay.com.br\/landing3723258331\/boleto\/202111DU1G0TNW42N20G7OCN46A2D8Q12101344","bankLine":"03399022070600000202905410101017588020000003000","bankNumber":202054101},"Antifraud":{"ip":null,"sessionId":null,"sent":false,"approved":null},"Pix":{"qrCode":"00020101021226860014BR.GOV.BCB.PIX2564api.rendimento.com.br\/q\/v2\/cobv\/5f8d7deaeccc41c1b3095adb5e0164ab5204000053039865802BR5925DAYANNE BARBARA RAMOS REZ6014Belo Horizonte61083057544062070503***63049768","image":"https:\/\/data.galaxpay.com.br\/landing3723258331\/pix\/YW4M9PDRHUEPHLC3SIUL0000000607","page":"https:\/\/gpay.com.br\/q\/17323\/17147dee"}}}';
        
        $bodyWebhook = '"Subscription":{"myId":"947","galaxPayId":239,"value":3000,"paymentLink":"https:\/\/gpay.com.br\/c\/17323\/239\/c","mainPaymentMethodId":"creditcard","status":"active","additionalInfo":null,"createdAt":"2021-11-12 17:06:47","updatedAt":"2021-11-12 17:06:47","quantity":0,"periodicity":"weekly","firstPayDayDate":"2021-11-12","Customer":{"myId":"1","galaxPayId":1,"name":"Reteste testeeeee teste","document":"61368543090","createdAt":"2021-05-13 16:49:48","updatedAt":"2021-11-12 17:06:47","emails":[],"phones":[],"Address":{"zipCode":"30411325","street":"Rua S\u00e3o Jo\u00e3o, 11","number":"1375","complement":"Prado","neighborhood":"Prado","city":"BElo Ho","state":"MG"},"ExtraFields":[]},"ExtraFields":[],"PaymentMethodCreditCard":{"cardOperatorId":"cielo","preAuthorize":false,"Card":{"myId":null,"galaxPayId":108,"number":"4111********1111","createdAt":"2021-11-12 17:06:47","updatedAt":"2021-11-12 17:06:47","Brand":{"id":"visa","name":"Visa","maxInstallment":null,"operatorIds":null}}}},"Transaction":{"galaxPayId":632,"value":3000,"payday":"2021-11-12","paydayDate":"2021-11-12 17:06:49","installment":1,"status":"captured","statusDescription":"Capturada na Operadora","createdAt":"2021-11-12 17:06:47","myId":"947","additionalInfo":null,"datetimeLastSentToOperator":"2021-11-12 17:06:48","subscriptionMyId":"947","subscriptionGalaxPayId":239,"payedOutsideGalaxPay":false,"tid":"1112050649012","authorizationCode":"089512","Boleto":{"pdf":"https:\/\/data.galaxpay.com.br\/landing3723258331\/boleto\/202111H5FLR7OCVEHWVAS4XP2D7KHCE12170647","bankLine":null,"bankNumber":null},"Antifraud":{"ip":null,"sessionId":null,"sent":false,"approved":null},"CreditCard":{"Card":{"myId":null,"galaxPayId":108,"number":"4111********1111","createdAt":"2021-11-12 17:06:47","updatedAt":"2021-11-12 17:06:47","Brand":{"id":"visa","name":"Visa","maxInstallment":null,"operatorIds":null}}}}}';
        $raw_body = '{"event":"transaction.updateStatus","webhookId":"6332904","confirmHash":"9fab2a141d9effa5e1c4cf4f5487f5bd",' . $bodyWebhook;
        */
        
        $this->debug('raw_body ' . $raw_body);
        $body = json_decode($raw_body, true);
        $this->body = $body;

        $this->container->logger->log('Novo Webhook chamado: ' . $raw_body);

        try {
            $this->process_event();
        } catch (Exception $e) {
            $this->debug('exception ' . $e->getMessage());
            $this->container->logger->log($e->getMessage());
        }
    }

    protected function process_event()
    {
        if (!isset($this->body['event'])) {
            $this->container->logger->log('evento nao encontrado no body');
            $this->stop(404, 'evento nao encontrado no body');
        }
        $eventResponse = $this->body['event'];
        if (!$eventResponse == 'transaction.updateStatus') {
            $this->container->logger->log('Evento do webhook ignorado pelo plugin: ' . $eventResponse);
            $this->stop(200, 'evento nao lido');
        }
        $this->isValid();
        $this->container->logger->log('Novo Evento processado: ' . $eventResponse);
        return $this->processTransaction();
    }

    protected function stop($code, $message)
    {
        $this->debug('stop ' . $code . ': ' . $message);
        $this->container->logger->log('webhook error stop ' . $code . ' - ' . $message);
        http_response_code($code);
        die($message);
    }

    protected function isValid()
    {
        return true;
        if ($this->body['confirmHash'] == $this->container->getGalaxTokenWebhook()) {
            return true;
        }
        $this->stop(401, 'unauthorized');
    }

    protected function processTransaction()
    {

        $metodo = 'action' . ucfirst($this->body['Transaction']['status']);
        if (!method_exists($this, $metodo)) {
            die($metodo);
            $this->stop(500, 'action not found: ' . $metodo);
        }
        $this->debug('ir realizar o metodo ' . $metodo);

        if (isset($this->body['Subscription'])) {
            $this->bill = $this->body['Subscription'];
            $this->isSubscription = true;
            $this->debug('identificou como assinatura');
        } else {
            $this->bill = $this->body['Charge'];
        }
        $this->$metodo($this->body);
    }

    protected function debug($message)
    {
        echo $message . '<hr>';
        $text = chr(13) . date('Y-m-d H:i') . '==>' . $message;
        if (GALAXPAY_DEEP_LOG) {
            $file_log = __DIR__ . '/logs/log-webhook_' . date('Ymd') . '.txt';
            $fp = fopen($file_log, "a+");
            fwrite($fp, $text);
            fclose($fp);
        }
    }

    protected function processSubscriptionCancelByContract()
    {
        $this->debug('processSubscriptionCancelByContract');
        if ($this->isSubscription()) {
            $order = $this->findOrderById($this->bill['myId']);
            $subscription = $this->getSubscriptionByOrderId($order->id);
            $subscription->update_status('cancelled');
        }
    }

    protected function processSubscriptionPaid($paymentMessage)
    {
        $this->debug('processSubscriptionPaid');
        if ($this->isSubscription()) {
            $this->debug('isSubscription');
            $order = $this->findOrderById($this->bill['myId']);
            $subscription = $this->getSubscriptionByOrderId($order->id);
            if ($subscription->status == 'on-hold') {
                $subscription->update_status('active');
            }
            if ($this->body['Transaction']['myId'] == '') {
                //senao tem myId irá criar um novo pagamento no wordpress para ser referente a essa transação do galax pay
                $this->createNewOrderToTransaction($subscription, true, $paymentMessage);
            }
            $subscription->add_order_note($paymentMessage . ' ' . $this->getDefaultMessageTransaction());
            $nextPayment = $this->getNextPayment($order->id);
            if ($nextPayment) {
                $subscription->update_dates(array('next_payment' => $nextPayment));
            }
        } else {
            $this->debug('NOT isSubscription');
        }
    }

    protected function processSubscriptionNotPaid($paymentMessage)
    {
        $this->debug('processSubscriptionNotPaid');       
        
        if ($this->isSubscription()) {
            $this->debug('isSubscription');
            $order = $this->findOrderById($this->bill['myId']);
            $subscription = $this->getSubscriptionByOrderId($order->id);
            if ($this->body['Transaction']['myId'] == '') {
                //senao tem myId irá criar um novo pagamento no wordpress para ser referente a essa transação do galax pay
                $this->createNewOrderToTransaction($subscription, false, $paymentMessage);
            }
            $subscription->add_order_note($paymentMessage . ' ' . $this->getDefaultMessageTransaction());
        } else {
            $this->debug('NOT isSubscription');
        }
    }

    protected function getSubscriptionByOrderId($orderId)
    {
        $this->debug('getSubscriptionByOrderId ' . $orderId);
        $subscriptions = wcs_get_subscriptions_for_order($orderId, array('order_type' => 'parent'));
        $subscriptions = end($subscriptions);
        $this->debug('getSubscriptionByOrderId return  ' . print_r($subscriptions, true));
        return $subscriptions;
    }

    protected function isSubscription()
    {
        return $this->isSubscription;
    }

    protected function getOrderIdsSorted($subscription)
    {
        if ($subscription === false || !is_object($subscription)) {
            $this->stop(500, 'get order subscription failed');
        }
        $ids = $subscription->get_related_orders();
        $this->debug('getSubscriptionByOrderId ' . print_r($ids));
        asort($ids);
        $correctKeyIds = array();
        foreach ($ids as $id) {
            $correctKeyIds[] = $id;
        }
        return $correctKeyIds;
    }

    protected function findOrderById($id)
    {
        $order = wc_get_order($id);
        $this->debug('findOrderById ' . $id);
        if (empty($order)) {
            $this->stop(500, 'Pedido #' . $id . ' não encontrado!');
        }

        return $order;
    }

    private function getNextPayment($orderId)
    {
        $subscription = $this->container->api->getSubscriptionById($orderId);
        $nextTransactionKey = $this->body['Transaction']['installment'];
        $nextTransaction = $subscription['Subscriptions'][0]['Transactions'][$nextTransactionKey];
        if ($nextTransaction) {
            $nextPaymentDate = $nextTransaction['payday'];
            return $nextPaymentDate . ' 12:00:00';
        }
        return false;
    }
    
    private function createNewOrderToTransaction($subscription, $isPaid, $paymentMessage)
    {
        if ($subscription->status == 'on-hold' && !$isPaid) {
            $subscription->update_status('active'); //forço a assinatura ficar ativa para o renewal funcionar
        }
        WC_Subscriptions_Manager::prepare_renewal($subscription->id);
        $newOrderId = $subscription->get_last_order();
        $this->container->api->putIdOrderAtTransaction($newOrderId, $this->body['Transaction']['galaxPayId']);
        $newOrder = $this->findOrderById($newOrderId);
        $this->addDefaultPostMeta($newOrder);
        $newOrder->add_order_note('Novo pedido criado referente a ' . $this->getDefaultMessageTransaction());
        if ($isPaid) {
            $new_status = GalaxPayDefaultStatus::getOrderDefaultStatus();
        } else {
            $new_status = 'failed';
        }
        $newOrder->update_status($new_status, $paymentMessage . ' ' . $this->getDefaultMessageTransaction());
    }
   

}
