<?php

abstract class GalaxPayBaseGateway extends WC_Payment_Gateway
{

    protected $validated = true;
    public $container;
    protected $paymentMethod;

    use GalaxPayGetInfoOrder;

    public static $adicionouFee = false;

    public function __construct(GalaxPaySettings $container)
    {
        $this->container = $container;
        $this->title = $this->get_option('title');
        $this->enabled = $this->get_option('enabled');
        $this->icon = 'https://app.galaxpay.com.br/view/images/favicon.ico';
        if (isset($_POST['payment_method'])) {
            $this->paymentMethod = sanitize_text_field($_POST['payment_method']);
        }
        if (is_admin()) {
            add_action('woocommerce_update_options_payment_gateways_' . $this->id, array(&$this, 'process_admin_options'));
        }

        add_action('woocommerce_before_calculate_totals', array(&$this, 'change_tax_class_based_on_payment_method'));
        add_action('wp_footer', array(&$this, 'payment_methods_trigger_update_checkout'));
        add_action('woocommerce_checkout_create_order', array(&$this, 'addFeeToOrder'));
    }

    public function addFeeToOrder($order)
    {
        if (self::$adicionouFee) {
            return;
        }
        // echo ' woocommerce_checkout_create_order';
        // Get order total
        $total = $order->get_total();

        $totalByPayment = $total;

        $chosen_payment_method = WC()->session->get('chosen_payment_method');
        if ($chosen_payment_method == "galax-pay-credit-card") {
            $credit = new GalaxPayCreditCard(new GalaxPaySettings());
            $totalByPayment = $credit->get_final_cost($total, $this->getInstallments());
        }
        //  $totalByPayment -= $total; 
        // Set the new calculated total
        $order->set_total($totalByPayment);
        self::$adicionouFee = true;
        //    var_dump($totalByPayment);
        // $order->add_fee( 'Juros',$totalByPayment, true );
    }

    function change_tax_class_based_on_payment_method($cart)
    {
        // Only for a specific defined payment meyhod
        if (WC()->session->get('chosen_payment_method') !== 'wdc_woo_credits')
            return;

        if (is_admin() && !defined('DOING_AJAX'))
            return;

        if (did_action('woocommerce_before_calculate_totals') >= 2)
            return;

        // Loop through cart items
        foreach ($cart->get_cart() as $cart_item) {
            // We set "Zero rate" tax class
            //   $cart_item['data']->set_tax_class("Zero rate");
        }
    }

    function payment_methods_trigger_update_checkout()
    {
        if (is_checkout() && !is_wc_endpoint_url()) :
            ?>
            <script type="text/javascript">
                jQuery(function ($) {
                    $('form.checkout').on('change', 'input[name="payment_method"]', function () {
                        $(document.body).trigger('update_checkout');
                    });
                });
            </script>
            <?php

        endif;
    }

    public function admin_options()
    {
        $this->container->get_template('admin-gateway-settings.html.php', array('gateway' => $this));
    }

    public function get_country_code()
    {
        if (isset($_GET['order_id'])) {
            $order = new WC_Order($_GET['order_id']);
            return $order->billing_country;
        } elseif ($this->container->woocommerce->customer->get_billing_country()) {
            return $this->container->woocommerce->customer->get_billing_country();
        }
    }

    public function validateSettings()
    {
        $currency = get_option('woocommerce_currency');
        return in_array($currency, ['BRL']);
    }

    public function process_payment($order_id)
    {
        $this->container->logger->log(sprintf('Processando pedido %s.', $order_id));
        $order = wc_get_order($order_id);
        $payment = new GalaxPayPayment($order, $this, $this->container);

        if (!$this->validated) {
            return false;
        }

        if (!$this->validateSettings()) {
            return $payment->abort(__('Pagamento cancelado devido à um erro de configuração. Entre em contato.', GALAX_IDENTIFIER));
        }

        try {
            $response = $payment->process($this->paymentMethod, $this);
            $order->reduce_order_stock();
        } catch (Exception $e) {
            $response = array(
                'result' => 'fail',
                'redirect' => ''
            );
            return $payment->abort(__($e->getMessage(), GALAX_IDENTIFIER));
            $this->container->logger->log($e->getMessage());
        }
        return $response;
    }

    protected function is_single_order()
    {
        $types = [];
        foreach ($this->container->woocommerce->cart->cart_contents as $item) {
            $types[] = $item['data']->get_type();
        }
        return !(bool) preg_grep('/subscription/', $types);
    }

}
