<?php

trait GalaxActionStatusWebhook
{

    protected function actionCaptured()
    {
        $this->debug('actionCaptured ');
        
        $paymentMessage = 'O pagamento foi realizado com sucesso pelo Galax Pay. Pagamento capturado na operadora.';
        $this->processAction(GalaxPayDefaultStatus::getOrderDefaultStatus(), $paymentMessage);
        $this->processSubscriptionPaid($paymentMessage);
    }

    protected function actionPayExternal()
    {
        $this->debug('actionPayExternal ');
        
        $paymentMessage = 'Pagamento feito fora do sistema do Galax Pay.';
        $this->processAction(GalaxPayDefaultStatus::getOrderDefaultStatus(), $paymentMessage);
        $this->processSubscriptionPaid($paymentMessage);
    }
    
    protected function actionPayedBoleto()
    {
        $this->debug('actionPayedBoleto ');
        
        $paymentMessage = 'Boleto pago processado pelo Galax Pay.';
        $this->processAction(GalaxPayDefaultStatus::getOrderDefaultStatus(), $paymentMessage);
        $this->processSubscriptionPaid($paymentMessage);
    }
    
    protected function actionPayedPix()
    {
        $this->debug('actionPayedPix');
        
        $paymentMessage = 'Pix pago processado pelo Galax Pay.';
        $this->processAction(GalaxPayDefaultStatus::getOrderDefaultStatus(), $paymentMessage);
        $this->processSubscriptionPaid($paymentMessage);
    }
    
    private function processAction($new_status, $paymentMessage)
    {
        if ($this->bill['myId']) {
            $order = $this->findOrderById($this->bill['myId']);
            $this->updateOrderStatus($order, $new_status, $paymentMessage);
        } else if (!$this->isSubscription()) {
            $this->stop(500, 'venda deveria vir com o myId preenchido');
        }
    }

    protected function actionDenied()
    {
        $this->debug('actionDenied ');
        
        $paymentMessage = 'O pagamento foi negado na operadora.';
        $this->processAction('failed', $paymentMessage);
        $this->processSubscriptionNotPaid($paymentMessage);
    }
    
    protected function actionNotCompensated()
    {
        $this->debug('actionNotCompensated ');
        
        $paymentMessage = 'O boleto foi baixado por decurso de prazo.';
        $this->processAction('failed', $paymentMessage);
        $this->processSubscriptionNotPaid($paymentMessage);
    }
    
    protected function actionUnavailablePix()
    {
        $this->debug('actionUnavailablePix ');
        
        $paymentMessage = 'Pix Indisponível para pagamento.';
        $this->processAction('failed', $paymentMessage);
        $this->processSubscriptionNotPaid($paymentMessage);
    }

    protected function actionCancel()
    {
        $this->debug('actionCancel');
        
        if ($this->isSubscription()) {
            return;
        }
        $order = $this->findOrderById($this->bill['myId']);
        $new_status = 'cancelled';
        $this->debug($this->bill['myId'] . ' -  new_status ' . $new_status);
        $order->update_status($new_status, 'Transação cancelada manualmente pelo Galax Pay. ' . $this->getDefaultMessageTransaction());
    }
    
    protected function actionCancelByContract()
    {
        $this->debug('actionCancelByContract');
        
        $order = $this->findOrderById($this->bill['myId']);
        $new_status = 'cancelled';
        $this->debug($this->bill['myId'] . ' -  new_status ' . $new_status);
        $order->update_status($new_status, 'O pagamento foi cancelado manualmente no Galax Pay. ' . $this->getDefaultMessageTransaction());
        $this->processSubscriptionCancelByContract();
    }

    protected function actionReversed()
    {
        $this->debug('actionReversed ');
        /* em estornos, mudamos a assinatura para cancelada também */
        if ($this->isSubscription()) {
            if (empty($this->body['Transaction']['myId'])) {
                $this->stop(500, 'Transaction id vazio');
            }
            
            $orderIdToReverse = $this->body['Transaction']['myId'];
            $orderToReverse = $this->findOrderById($orderIdToReverse);
            $orderToReverse->update_status('refunded', 'A transação foi estornada na operadora. Transação #' . $this->body['Transaction']['galaxPayId'] . ' no Galax Pay.');
         
            $orderParentId = $this->bill['myId'];
            $subscription = $this->getSubscriptionByOrderId($orderParentId);
            $subscription->update_status('cancelled', 'A transação foi estornada no Galax Pay. Transação #' . $this->body['Transaction']['galaxPayId'] . ' no Galax Pay.');
        } else {
            $order = $this->findOrderById($this->bill['myId']);
            if (empty($this->bill['myId'])) {
                $this->stop(500, 'Bill id vazio charge');
            }
            $new_status = 'refunded';
            $order->update_status($new_status, 'O pagamento foi estornado na operadora. Transação #' . $this->body['Transaction']['galaxPayId'] . ' no Galax Pay.');
        }
    }
    
    private function getDefaultMessageTransaction()
    {
        return 'Transação #' . $this->body['Transaction']['galaxPayId'] . ' no Galax Pay.';
    }
    
    private function addDefaultPostMeta($newOrder)
    {
        add_post_meta($newOrder->id, 'galaxPayBill', $this->bill['galaxPayId']);
        add_post_meta($newOrder->id, 'galaxPayTransaction', $this->body['Transaction']['galaxPayId']);
        add_post_meta($newOrder->id, 'galaxCustomerId', $this->bill['Customer']['myId']);
    }
    
    private function updateOrderStatus($order, $new_status, $paymentMessage)
    {
        $this->debug($this->bill['myId'] . ' -  new_status ' . $new_status);
        $order->update_status($new_status, $paymentMessage . ' ' . $this->getDefaultMessageTransaction());
    }

}
